/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.c.CommuneWithLavaMayPlayEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class CommuneWithLavaEffect
extends OneShotEffect {
    CommuneWithLavaEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "Exile the top X cards of your library. Until the end of your next turn, you may play those cards";
    }

    private CommuneWithLavaEffect(CommuneWithLavaEffect effect) {
        super((OneShotEffect)effect);
    }

    public CommuneWithLavaEffect copy() {
        return new CommuneWithLavaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card sourceCard = game.getCard(source.getSourceId());
        if (controller != null && sourceCard != null) {
            int amount = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
            Set cards = controller.getLibrary().getTopCards(game, amount);
            controller.moveCardsToExile(cards, source, game, true, CardUtil.getCardExileZoneId((Game)game, (Ability)source), sourceCard.getIdName());
            for (Card card : cards) {
                CommuneWithLavaMayPlayEffect effect = new CommuneWithLavaMayPlayEffect();
                effect.setTargetPointer((TargetPointer)new FixedTarget(card.getId(), game));
                game.addEffect((ContinuousEffect)effect, source);
            }
            return true;
        }
        return false;
    }
}

