/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnFromGraveyardToBattlefieldTargetEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ConcoctEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCreatureCard("creature card in your graveyard");

    public ConcoctEffect() {
        super(Outcome.Benefit);
        this.staticText = "Surveil 3, then return a creature card from your graveyard to the battlefield.";
    }

    private ConcoctEffect(ConcoctEffect effect) {
        super((OneShotEffect)effect);
    }

    public ConcoctEffect copy() {
        return new ConcoctEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        player.surveil(3, source, game);
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(filter);
        target.withNotTarget(true);
        if (player.choose(this.outcome, (Target)target, source, game)) {
            ReturnFromGraveyardToBattlefieldTargetEffect effect = new ReturnFromGraveyardToBattlefieldTargetEffect();
            effect.setTargetPointer((TargetPointer)new FixedTarget(target.getFirstTarget(), game));
            effect.apply(game, source);
        }
        return true;
    }
}

