/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class CondemnEffect
extends OneShotEffect {
    CondemnEffect() {
        super(Outcome.Detriment);
        this.staticText = "Its controller gains life equal to its toughness";
    }

    private CondemnEffect(CondemnEffect effect) {
        super((OneShotEffect)effect);
    }

    public CondemnEffect copy() {
        return new CondemnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        Permanent permanent = (Permanent)game.getLastKnownInformation(source.getFirstTarget(), Zone.BATTLEFIELD);
        if (permanent != null && (player = game.getPlayer(permanent.getControllerId())) != null) {
            player.gainLife(permanent.getToughness().getValue(), game, source);
            return true;
        }
        return false;
    }
}

