/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.EscapeAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;

class ConfessionDialEffect
extends ContinuousEffectImpl {
    ConfessionDialEffect() {
        super(Duration.EndOfTurn, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "Target legendary creature card in your graveyard gains escape until end of turn. The escape cost is equal to its mana cost plus exile three other cards from your graveyard. <i>(You may cast it from your graveyard for its escape cost this turn.)</i>";
    }

    private ConfessionDialEffect(ConfessionDialEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (card == null || card.getManaCost().getText().isEmpty()) {
            return false;
        }
        EscapeAbility ability = new EscapeAbility(card, card.getManaCost().getText(), 3);
        ability.setSourceId(card.getId());
        ability.setControllerId(card.getOwnerId());
        game.getState().addOtherAbility(card, (Ability)ability);
        return true;
    }

    public ConfessionDialEffect copy() {
        return new ConfessionDialEffect(this);
    }
}

