/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class ConfoundingConundrumEffect
extends OneShotEffect {
    ConfoundingConundrumEffect() {
        super(Outcome.Benefit);
        this.staticText = "they return a land they control to its owner's hand";
    }

    private ConfoundingConundrumEffect(ConfoundingConundrumEffect effect) {
        super((OneShotEffect)effect);
    }

    public ConfoundingConundrumEffect copy() {
        return new ConfoundingConundrumEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(1, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_LAND);
        target.withNotTarget(true);
        if (!target.canChoose(player.getId(), source, game)) {
            return false;
        }
        player.choose(this.outcome, (Target)target, source, game);
        return player.moveCards(game.getCard(target.getFirstTarget()), Zone.HAND, source, game);
    }
}

