/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.common.AsEntersBattlefieldAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ChooseCreatureTypeEffect;
import mage.cards.Card;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.command.CommandObject;
import mage.game.command.Commander;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.players.Player;
import mage.util.SubTypes;

public final class Conspiracy
extends CardImpl {
    public Conspiracy(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{3}{B}{B}");
        this.addAbility((Ability)new AsEntersBattlefieldAbility((Effect)new ChooseCreatureTypeEffect(Outcome.Neutral)));
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new ConspiracyEffect()));
    }

    private Conspiracy(Conspiracy card) {
        super((CardImpl)card);
    }

    public Conspiracy copy() {
        return new Conspiracy(this);
    }

    static class ConspiracyEffect
    extends ContinuousEffectImpl {
        private ConspiracyEffect() {
            super(Duration.WhileOnBattlefield, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Neutral);
            this.staticText = "Creatures you control are the chosen type. The same is true for creature spells you control and creature cards you own that aren't on the battlefield.";
            this.dependendToTypes.add(DependencyType.BecomeCreature);
        }

        private ConspiracyEffect(ConspiracyEffect effect) {
            super((ContinuousEffectImpl)effect);
        }

        public ConspiracyEffect copy() {
            return new ConspiracyEffect(this);
        }

        public boolean apply(Game game, Ability source) {
            Card card;
            Player controller = game.getPlayer(source.getControllerId());
            SubType subType = ChooseCreatureTypeEffect.getChosenCreatureType((UUID)source.getSourceId(), (Game)game);
            if (controller == null || subType == null) {
                return true;
            }
            for (UUID cardId : controller.getGraveyard()) {
                card = game.getCard(cardId);
                if (card == null || !card.isCreature(game)) continue;
                this.setCreatureSubtype((MageObject)card, subType, game);
            }
            for (UUID cardId : controller.getHand()) {
                card = game.getCard(cardId);
                if (card == null || !card.isCreature(game)) continue;
                this.setCreatureSubtype((MageObject)card, subType, game);
            }
            for (Card card2 : game.getState().getExile().getCardsOwned(game, controller.getId())) {
                if (!card2.isCreature(game)) continue;
                this.setCreatureSubtype((MageObject)card2, subType, game);
            }
            for (Card card2 : controller.getLibrary().getCards(game)) {
                if (!card2.isCreature(game)) continue;
                this.setCreatureSubtype((MageObject)card2, subType, game);
            }
            for (CommandObject commandObject : game.getState().getCommand()) {
                if (!(commandObject instanceof Commander) || (card = game.getCard(((Commander)commandObject).getId())) == null || !card.isCreature(game) || !card.isOwnedBy(controller.getId())) continue;
                this.setCreatureSubtype((MageObject)card, subType, game);
            }
            for (StackObject stackObject : game.getStack()) {
                if (!(stackObject instanceof Spell) || !stackObject.isControlledBy(controller.getId()) || !stackObject.isCreature(game)) continue;
                this.setCreatureSubtype((MageObject)stackObject, subType, game);
                this.setCreatureSubtype((MageObject)((Spell)stackObject).getCard(), subType, game);
            }
            List permanents = game.getBattlefield().getAllActivePermanents(controller.getId());
            for (Permanent permanent : permanents) {
                if (!permanent.isCreature(game)) continue;
                permanent.removeAllCreatureTypes(game);
                permanent.addSubType(game, new SubType[]{subType});
            }
            return true;
        }

        private void setCreatureSubtype(MageObject object, SubType subtype, Game game) {
            if (object == null) {
                return;
            }
            SubTypes subTypes = game.getState().getCreateMageObjectAttribute(object, game).getSubtype();
            subTypes.setIsAllCreatureTypes(false);
            subTypes.removeAll((Collection)SubType.getCreatureTypes());
            subTypes.add((Object)subtype);
        }
    }
}

