/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.util.CardUtil;

class ConspiracyTheoristEffect
extends OneShotEffect {
    private final Set<Card> discardedCards;

    ConspiracyTheoristEffect(Set<Card> discardedCards) {
        super(Outcome.Benefit);
        this.discardedCards = discardedCards;
    }

    private ConspiracyTheoristEffect(ConspiracyTheoristEffect effect) {
        super((OneShotEffect)effect);
        this.discardedCards = effect.discardedCards;
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card card2;
            CardsImpl cards = new CardsImpl(this.discardedCards);
            TargetCard target = new TargetCard(Zone.GRAVEYARD, new FilterCard("card to exile"));
            boolean validTarget = cards.stream().anyMatch(card -> target.canTarget(card, source, game));
            if (validTarget && controller.chooseUse(Outcome.Benefit, "Exile a card?", source, game) && controller.choose(Outcome.Benefit, (Cards)cards, target, source, game) && (card2 = cards.get(target.getFirstTarget(), game)) != null && controller.moveCards(card2, Zone.EXILED, source, game)) {
                CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card2, (boolean)true, (Duration)Duration.EndOfTurn, (boolean)false);
            }
            return true;
        }
        return false;
    }

    public ConspiracyTheoristEffect copy() {
        return new ConspiracyTheoristEffect(this);
    }
}

