/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.LinkedHashSet;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.OnLeaveReturnExiledAbility;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterArtifactPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class ConsulateCracksownExileEffect
extends OneShotEffect {
    private static final FilterArtifactPermanent filter = new FilterArtifactPermanent("artifacts your opponents control");

    public ConsulateCracksownExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile all artifacts your opponents control until {this} leaves the battlefield";
    }

    private ConsulateCracksownExileEffect(ConsulateCracksownExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null || controller == null) {
            return false;
        }
        LinkedHashSet<Permanent> toExile = new LinkedHashSet<Permanent>();
        for (Permanent artifact : game.getBattlefield().getActivePermanents((FilterPermanent)filter, controller.getId(), game)) {
            toExile.add(artifact);
        }
        if (!toExile.isEmpty()) {
            controller.moveCardsToExile(toExile, source, game, true, CardUtil.getCardExileZoneId((Game)game, (Ability)source), permanent.getIdName());
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new OnLeaveReturnExiledAbility(), source);
        }
        return true;
    }

    public ConsulateCracksownExileEffect copy() {
        return new ConsulateCracksownExileEffect(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.OPPONENT.getControllerPredicate());
    }
}

