/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.BatchTriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.ProliferateEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.BatchEvent;
import mage.game.events.DamagedBatchForPlayersEvent;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class ContaminantGrafterTriggeredAbility
extends TriggeredAbilityImpl
implements BatchTriggeredAbility<DamagedPlayerEvent> {
    ContaminantGrafterTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new ProliferateEffect(false), false);
        this.setTriggerPhrase("Whenever one or more creatures you control deal combat damage to one or more players, ");
    }

    private ContaminantGrafterTriggeredAbility(ContaminantGrafterTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_BATCH_FOR_PLAYERS;
    }

    public boolean checkEvent(DamagedPlayerEvent event, Game game) {
        if (!event.isCombatDamage()) {
            return false;
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getSourceId());
        return permanent != null && permanent.isCreature(game) && permanent.isControlledBy(this.getControllerId());
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return !this.getFilteredEvents((BatchEvent)((DamagedBatchForPlayersEvent)event), game).isEmpty();
    }

    public ContaminantGrafterTriggeredAbility copy() {
        return new ContaminantGrafterTriggeredAbility(this);
    }
}

