/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheEndOfCombatDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnToHandSourceEffect;
import mage.abilities.effects.common.ReturnToHandTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ContemptEffect
extends OneShotEffect {
    ContemptEffect() {
        super(Outcome.Detriment);
        this.staticText = "return it and {this} to their owners' hands at end of combat.";
    }

    private ContemptEffect(ContemptEffect effect) {
        super((OneShotEffect)effect);
    }

    public ContemptEffect copy() {
        return new ContemptEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent contempt = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (contempt != null) {
            ReturnToHandSourceEffect effect = new ReturnToHandSourceEffect();
            AtTheEndOfCombatDelayedTriggeredAbility ability = new AtTheEndOfCombatDelayedTriggeredAbility((Effect)effect);
            Permanent attachedToPermanent = game.getPermanent(contempt.getAttachedTo());
            if (attachedToPermanent != null) {
                effect = new ReturnToHandTargetEffect();
                effect.setTargetPointer((TargetPointer)new FixedTarget(attachedToPermanent.getId(), game)).setText("return " + attachedToPermanent.getName() + " to owner's hand.");
                ability.addEffect((Effect)effect);
            }
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)ability, source);
            return true;
        }
        return false;
    }
}

