/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.BatchTriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.c.ContestedGameBallEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedBatchForOnePlayerEvent;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ContestedGameBallTriggeredAbility
extends TriggeredAbilityImpl
implements BatchTriggeredAbility<DamagedPlayerEvent> {
    ContestedGameBallTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new ContestedGameBallEffect());
        this.setTriggerPhrase("Whenever you're dealt combat damage, ");
    }

    private ContestedGameBallTriggeredAbility(ContestedGameBallTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_BATCH_FOR_ONE_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (((DamagedBatchForOnePlayerEvent)event).isCombatDamage() && event.getTargetId().equals(this.getControllerId())) {
            this.getAllEffects().setTargetPointer((TargetPointer)new FixedTarget(game.getActivePlayerId()));
            return true;
        }
        return false;
    }

    public ContestedGameBallTriggeredAbility copy() {
        return new ContestedGameBallTriggeredAbility(this);
    }
}

