/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.condition.common.AddendumCondition;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;

class ContractualSafeguardFirstEffect
extends OneShotEffect {
    ContractualSafeguardFirstEffect() {
        super(Outcome.Benefit);
        this.staticText = "if you cast this spell during your main phase, put a shield counter on a creature you control";
    }

    private ContractualSafeguardFirstEffect(ContractualSafeguardFirstEffect effect) {
        super((OneShotEffect)effect);
    }

    public ContractualSafeguardFirstEffect copy() {
        return new ContractualSafeguardFirstEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (!AddendumCondition.instance.apply(game, source)) {
            return false;
        }
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || !game.getBattlefield().contains((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source, game, 1)) {
            return false;
        }
        TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent();
        target.withChooseHint("to give a shield counter").withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        return permanent != null && permanent.addCounters(CounterType.SHIELD.createInstance(), source, game);
    }
}

