/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.condition.common.ControlYourCommanderCondition;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class ConvergenceOfDominionEffect
extends CostModificationEffectImpl {
    ConvergenceOfDominionEffect() {
        super(Duration.Custom, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "as long as you control your commander, activated abilities of cards in your graveyard cost {2} less to activate. This effect can't reduce the mana in that ability's activation cost to less than one mana";
    }

    private ConvergenceOfDominionEffect(ConvergenceOfDominionEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        Player controller = game.getPlayer(abilityToModify.getControllerId());
        if (controller == null) {
            return false;
        }
        int reduceMax = CardUtil.calculateActualPossibleGenericManaReduction((Mana)abilityToModify.getManaCostsToPay().getMana(), (int)2, (int)1);
        if (reduceMax > 0) {
            CardUtil.reduceCost((Ability)abilityToModify, (int)reduceMax);
        }
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        return ControlYourCommanderCondition.instance.apply(game, source) && abilityToModify.isActivatedAbility() && game.getState().getZone(abilityToModify.getSourceId()) == Zone.GRAVEYARD;
    }

    public ConvergenceOfDominionEffect copy() {
        return new ConvergenceOfDominionEffect(this);
    }
}

