/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.DiscardCardCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.SacrificeSourceUnlessPaysEffect;
import mage.abilities.effects.common.continuous.GainAbilityAttachedEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.abilities.triggers.BeginningOfUpkeepTriggeredAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.AttachmentType;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class CoralNet
extends CardImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("green or white creature");
    private static final String rule = "Enchanted creature has \"At the beginning of your upkeep, sacrifice this creature unless you discard a card.\"";

    public CoralNet(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{U}");
        this.subtype.add((Object)SubType.AURA);
        TargetPermanent auraTarget = new TargetPermanent((FilterPermanent)filter);
        this.getSpellAbility().addTarget((Target)auraTarget);
        this.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.Detriment));
        this.addAbility((Ability)new EnchantAbility((Target)auraTarget));
        BeginningOfUpkeepTriggeredAbility abilityToGain = new BeginningOfUpkeepTriggeredAbility((Effect)new SacrificeSourceUnlessPaysEffect((Cost)new DiscardCardCost()));
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new GainAbilityAttachedEffect((Ability)abilityToGain, AttachmentType.AURA, Duration.WhileOnBattlefield, rule)));
    }

    private CoralNet(CoralNet card) {
        super((CardImpl)card);
    }

    public CoralNet copy() {
        return new CoralNet(this);
    }

    static {
        filter.add(Predicates.or((Predicate)new ColorPredicate(ObjectColor.WHITE), (Predicate)new ColorPredicate(ObjectColor.GREEN)));
    }
}

