/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.cards.c.CoramTheUndertakerWatcher;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;

class CoramTheUndertakerCastSpellFromGraveyardEffect
extends AsThoughEffectImpl {
    CoramTheUndertakerCastSpellFromGraveyardEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "During each of your turns, you may cast a spell from among cards in graveyards that were put there from libraries this turn.";
    }

    private CoramTheUndertakerCastSpellFromGraveyardEffect(CoramTheUndertakerCastSpellFromGraveyardEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public CoramTheUndertakerCastSpellFromGraveyardEffect copy() {
        return new CoramTheUndertakerCastSpellFromGraveyardEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        if (!(source.isControlledBy(affectedControllerId) && affectedControllerId.equals(game.getActivePlayerId()) && Zone.GRAVEYARD.equals((Object)game.getState().getZone(objectId)))) {
            return false;
        }
        CoramTheUndertakerWatcher watcher = (CoramTheUndertakerWatcher)game.getState().getWatcher(CoramTheUndertakerWatcher.class);
        Card card = game.getCard(objectId);
        return card != null && watcher != null && watcher.cardPutFromGraveyardThisTurn(new MageObjectReference((MageObject)card.getMainCard(), game)) && !watcher.spellCastFromGraveyard(source, game);
    }
}

