/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.assignment.common.SubTypeAssignment;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.target.common.TargetCardInLibrary;

class CorpseHarvesterTarget
extends TargetCardInLibrary {
    private static final FilterCard filter = new FilterCard("a Zombie card and a Swamp card");
    private static final SubTypeAssignment subTypeAssigner;

    CorpseHarvesterTarget() {
        super(0, 2, filter);
    }

    private CorpseHarvesterTarget(CorpseHarvesterTarget target) {
        super((TargetCardInLibrary)target);
    }

    public CorpseHarvesterTarget copy() {
        return new CorpseHarvesterTarget(this);
    }

    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        if (!super.canTarget(playerId, id, source, game)) {
            return false;
        }
        Card card = game.getCard(id);
        if (card == null) {
            return false;
        }
        if (this.getTargets().isEmpty()) {
            return true;
        }
        CardsImpl cards = new CardsImpl((Collection)this.getTargets());
        cards.add(card);
        return subTypeAssigner.getRoleCount((Cards)cards, game) >= cards.size();
    }

    static {
        filter.add(Predicates.or((Predicate)SubType.ZOMBIE.getPredicate(), (Predicate)SubType.SWAMP.getPredicate()));
        subTypeAssigner = new SubTypeAssignment(new SubType[]{SubType.ZOMBIE, SubType.SWAMP});
    }
}

