/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class CorrosionRemoveCountersEffect
extends OneShotEffect {
    CorrosionRemoveCountersEffect() {
        super(Outcome.Neutral);
        this.staticText = "remove all rust counters from all permanents";
    }

    private CorrosionRemoveCountersEffect(CorrosionRemoveCountersEffect effect) {
        super((OneShotEffect)effect);
    }

    public CorrosionRemoveCountersEffect copy() {
        return new CorrosionRemoveCountersEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents()) {
            permanent.removeAllCounters(CounterType.RUST.getName(), source, game);
        }
        return true;
    }
}

