/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.effects.common.continuous.SetBasePowerToughnessSourceEffect;
import mage.abilities.keyword.DefenderAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.VigilanceAbility;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class CorruptedShapeshifterReplacementEffect
extends ReplacementEffectImpl {
    private static final String choice33 = "a 3/3 creature with flying";
    private static final String choice25 = "a 2/5 creature with vigilance";
    private static final String choice012 = "a 0/12 creature with defender";

    public CorruptedShapeshifterReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "As {this} enters, it becomes your choice of a 3/3 creature with flying, a 2/5 creature with vigilance, or a 0/12 creature with defender";
    }

    private CorruptedShapeshifterReplacementEffect(CorruptedShapeshifterReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event.getTargetId().equals(source.getSourceId())) {
            Permanent sourcePermanent = ((EntersTheBattlefieldEvent)event).getTarget();
            return sourcePermanent != null && !sourcePermanent.isFaceDown(game);
        }
        return false;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent permanent = ((EntersTheBattlefieldEvent)event).getTarget();
        Player controller = game.getPlayer(source.getControllerId());
        if (permanent != null && controller != null) {
            ChoiceImpl choice = new ChoiceImpl(true);
            choice.setMessage("Choose what " + permanent.getIdName() + " becomes to");
            choice.getChoices().add(choice33);
            choice.getChoices().add(choice25);
            choice.getChoices().add(choice012);
            if (!controller.choose(Outcome.Neutral, (Choice)choice, game)) {
                return false;
            }
            int power = 0;
            int toughness = 0;
            switch (choice.getChoice()) {
                case "a 3/3 creature with flying": {
                    power = 3;
                    toughness = 3;
                    game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)FlyingAbility.getInstance(), Duration.Custom), source);
                    break;
                }
                case "a 2/5 creature with vigilance": {
                    power = 2;
                    toughness = 5;
                    game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)VigilanceAbility.getInstance(), Duration.Custom), source);
                    break;
                }
                case "a 0/12 creature with defender": {
                    power = 0;
                    toughness = 12;
                    game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)DefenderAbility.getInstance(), Duration.Custom), source);
                }
            }
            game.addEffect((ContinuousEffect)new SetBasePowerToughnessSourceEffect(power, toughness, Duration.WhileOnBattlefield), source);
        }
        return false;
    }

    public CorruptedShapeshifterReplacementEffect copy() {
        return new CorruptedShapeshifterReplacementEffect(this);
    }
}

