/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;

class CorruptionOfTowashiTriggeredAbility
extends TriggeredAbilityImpl {
    CorruptionOfTowashiTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DrawCardSourceControllerEffect(1), true);
        this.setTriggerPhrase("Whenever a permanent you control transforms or a permanent you control enters transformed, ");
        this.setDoOnlyOnceEachTurn(true);
    }

    private CorruptionOfTowashiTriggeredAbility(CorruptionOfTowashiTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public CorruptionOfTowashiTriggeredAbility copy() {
        return new CorruptionOfTowashiTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD || event.getType() == GameEvent.EventType.TRANSFORMED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.isControlledBy(game.getControllerId(event.getTargetId()))) {
            return false;
        }
        switch (event.getType()) {
            case ENTERS_THE_BATTLEFIELD: {
                return ((EntersTheBattlefieldEvent)event).getTarget().isTransformed();
            }
            case TRANSFORMED: {
                return true;
            }
        }
        return false;
    }
}

