/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.c.CosimaGodOfTheVoyageGainAbilityEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class CosimaGodOfTheVoyageEffect
extends OneShotEffect {
    CosimaGodOfTheVoyageEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile {this}. If you do, it gains \"Whenever a land you control enters, if {this} is exiled, you may put a voyage counter on it. If you don't, return {this} to the battlefield with X +1/+1 counters on it and draw X cards, where X is the number of voyage counters on it.\"";
    }

    private CosimaGodOfTheVoyageEffect(CosimaGodOfTheVoyageEffect effect) {
        super((OneShotEffect)effect);
    }

    public CosimaGodOfTheVoyageEffect copy() {
        return new CosimaGodOfTheVoyageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (player == null || permanent == null) {
            return false;
        }
        Card card = game.getCard(permanent.getId());
        if (card == null) {
            return false;
        }
        String exileName = "Exiled to the voyage";
        player.moveCardsToExile((Card)permanent, source, game, true, source.getSourceId(), exileName);
        if (game.getState().getZone(card.getId()) != Zone.EXILED) {
            return true;
        }
        game.addEffect((ContinuousEffect)new CosimaGodOfTheVoyageGainAbilityEffect(new MageObjectReference((MageObject)card, game)), source);
        return true;
    }
}

