/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class CosimaGodOfTheVoyageReturnEffect
extends OneShotEffect {
    CosimaGodOfTheVoyageReturnEffect() {
        super(Outcome.Benefit);
    }

    private CosimaGodOfTheVoyageReturnEffect(CosimaGodOfTheVoyageReturnEffect effect) {
        super((OneShotEffect)effect);
    }

    public CosimaGodOfTheVoyageReturnEffect copy() {
        return new CosimaGodOfTheVoyageReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Outcome aiOutcome;
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(source.getSourceId());
        if (player == null || card == null) {
            return false;
        }
        int currentCount = card.getCounters(game).getCount(CounterType.VOYAGE);
        Outcome outcome = aiOutcome = currentCount >= 2 ? Outcome.Benefit : Outcome.Detriment;
        if (player.chooseUse(aiOutcome, "Add a voyage counter (current: " + currentCount + ")?", null, "Yes, add counter", "No, return to battlefield", source, game) && card.addCounters(CounterType.VOYAGE.createInstance(), player.getId(), source, game)) {
            return true;
        }
        int newCount = card.getCounters(game).getCount(CounterType.VOYAGE);
        player.moveCards(card, Zone.BATTLEFIELD, source, game);
        if (newCount < 1) {
            return true;
        }
        player.drawCards(newCount, source, game);
        Permanent permanent = game.getPermanent(card.getId());
        if (permanent != null) {
            permanent.addCounters(CounterType.P1P1.createInstance(newCount), player.getId(), source, game);
        }
        return true;
    }
}

