/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.c.CosimaGodOfTheVoyageReturnEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class CosimaGodOfTheVoyageTriggeredAbility
extends TriggeredAbilityImpl {
    CosimaGodOfTheVoyageTriggeredAbility() {
        super(Zone.EXILED, (Effect)new CosimaGodOfTheVoyageReturnEffect());
    }

    private CosimaGodOfTheVoyageTriggeredAbility(CosimaGodOfTheVoyageTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        return permanent != null && permanent.isLand(game) && permanent.isControlledBy(this.getControllerId());
    }

    public boolean checkInterveningIfClause(Game game) {
        return game.getState().getZone(this.getSourceId()) == Zone.EXILED;
    }

    public CosimaGodOfTheVoyageTriggeredAbility copy() {
        return new CosimaGodOfTheVoyageTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever a land you control enters, if {this} is exiled, you may put a voyage counter on it. If you don't, return {this} to the battlefield with X +1/+1 counters on it and draw X cards, where X is the number of voyage counters on it.";
    }
}

