/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.c.CouncilsJudgmentVote;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class CouncilsJudgmentEffect
extends OneShotEffect {
    CouncilsJudgmentEffect() {
        super(Outcome.Exile);
        this.staticText = "<i>Will of the council</i> &mdash; Starting with you, each player votes for a nonland permanent you don't control. Exile each permanent with the most votes or tied for most votes";
    }

    private CouncilsJudgmentEffect(CouncilsJudgmentEffect effect) {
        super((OneShotEffect)effect);
    }

    public CouncilsJudgmentEffect copy() {
        return new CouncilsJudgmentEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CouncilsJudgmentVote vote = new CouncilsJudgmentVote(player);
        vote.doVotes(source, game);
        CardsImpl cards = new CardsImpl();
        vote.getMostVoted().stream().forEach(arg_0 -> ((Cards)cards).add(arg_0));
        return player.moveCards((Cards)cards, Zone.EXILED, source, game);
    }
}

