/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.LinkedList;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;

class CounterfluxEffect
extends OneShotEffect {
    CounterfluxEffect() {
        super(Outcome.Detriment);
        this.staticText = "Counter each spell you don't control.";
    }

    private CounterfluxEffect(CounterfluxEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        LinkedList<Spell> spellsToCounter = new LinkedList<Spell>();
        for (StackObject stackObject : game.getStack()) {
            if (!(stackObject instanceof Spell) || stackObject.isControlledBy(source.getControllerId())) continue;
            spellsToCounter.add((Spell)stackObject);
        }
        for (Spell spell : spellsToCounter) {
            game.getStack().counter(spell.getId(), source, game);
        }
        return true;
    }

    public CounterfluxEffect copy() {
        return new CounterfluxEffect(this);
    }
}

