/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.counters.Counter;
import mage.game.Game;
import mage.game.permanent.Permanent;

enum CountersDiedCreatureCount implements DynamicValue
{
    instance;


    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        if (sourceAbility == null || effect == null) {
            return 0;
        }
        Permanent creatureDied = (Permanent)effect.getValue("creatureDied");
        if (creatureDied == null) {
            return 0;
        }
        return creatureDied.getCounters(game).values().stream().mapToInt(Counter::getCount).sum();
    }

    public DynamicValue copy() {
        return instance;
    }

    public String getMessage() {
        return "counters on creature that died";
    }

    public String toString() {
        return "";
    }
}

