/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.keyword.ProtectionAbility;
import mage.cards.Card;
import mage.filter.Filter;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;

class CourageousResolveProtectionAbility
extends ProtectionAbility {
    private final Set<UUID> playerSet = new HashSet<UUID>();

    CourageousResolveProtectionAbility(Set<UUID> playerSet) {
        super((Filter)StaticFilters.FILTER_CARD);
        this.playerSet.addAll(playerSet);
    }

    private CourageousResolveProtectionAbility(CourageousResolveProtectionAbility ability) {
        super((ProtectionAbility)ability);
        this.playerSet.addAll(ability.playerSet);
    }

    public CourageousResolveProtectionAbility copy() {
        return new CourageousResolveProtectionAbility(this);
    }

    public String getRule() {
        return "{this} has protection from each opponent";
    }

    public boolean canTarget(MageObject source, Game game) {
        if (source instanceof Permanent) {
            return this.playerSet.stream().noneMatch(arg_0 -> ((Permanent)((Permanent)source)).isControlledBy(arg_0));
        }
        if (source instanceof Spell) {
            return this.playerSet.stream().noneMatch(arg_0 -> ((Spell)((Spell)source)).isControlledBy(arg_0));
        }
        if (source instanceof StackObject) {
            return this.playerSet.stream().noneMatch(arg_0 -> ((StackObject)((StackObject)source)).isControlledBy(arg_0));
        }
        if (source instanceof Card) {
            return this.playerSet.stream().noneMatch(arg_0 -> ((Card)((Card)source)).isOwnedBy(arg_0));
        }
        return true;
    }
}

