/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.c.CourtOfLocthwain;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class CourtOfLocthwainFirstEffect
extends OneShotEffect {
    CourtOfLocthwainFirstEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top card of target opponent's library. You may play that card for as long as it remains exiled, and mana of any type can be spent to cast it";
    }

    private CourtOfLocthwainFirstEffect(CourtOfLocthwainFirstEffect effect) {
        super((OneShotEffect)effect);
    }

    public CourtOfLocthwainFirstEffect copy() {
        return new CourtOfLocthwainFirstEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || opponent == null) {
            return false;
        }
        Card card = opponent.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        MageObject sourceObject = source.getSourceObject(game);
        if (sourceObject == null) {
            return false;
        }
        UUID exileId = CourtOfLocthwain.getExileZoneId(new MageObjectReference(sourceObject, game), game);
        String exileName = sourceObject.getIdName();
        controller.moveCardsToExile(card, source, game, true, exileId, exileName);
        if (game.getState().getZone(card.getId()) == Zone.EXILED) {
            CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)false, (Duration)Duration.EndOfGame, (boolean)true, (UUID)controller.getId(), null);
        }
        return true;
    }
}

