/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.MageIdentifier;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;
import mage.watchers.Watcher;

class CourtOfLocthwainWatcher
extends Watcher {
    private final Map<UUID, Map<MageObjectReference, Integer>> usageRemaining = new HashMap<UUID, Map<MageObjectReference, Integer>>();

    public CourtOfLocthwainWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.SPELL_CAST && event.hasApprovingIdentifier(MageIdentifier.CourtOfLocthwainWatcher) && event.getPlayerId() != null) {
            this.decrementCastAvailable(event.getPlayerId(), event.getApprovingObject().getApprovingMageObjectReference());
        }
    }

    public void reset() {
        this.usageRemaining.clear();
        super.reset();
    }

    private void decrementCastAvailable(UUID playerId, MageObjectReference mor) {
        Map<MageObjectReference, Integer> usageForPlayer;
        if (this.usageRemaining.containsKey(playerId) && (usageForPlayer = this.usageRemaining.get(playerId)).containsKey(mor)) {
            int newValue = usageForPlayer.get(mor) - 1;
            if (newValue > 0) {
                usageForPlayer.put(mor, newValue);
            } else {
                usageForPlayer.remove(mor);
            }
        }
    }

    void setOrIncrementCastAvailable(UUID playerId, MageObjectReference mor) {
        this.usageRemaining.computeIfAbsent(playerId, k -> new HashMap());
        this.usageRemaining.get(playerId).compute(mor, CardUtil::setOrIncrementValue);
    }

    int castStillAvailable(UUID playerId, MageObjectReference mor) {
        return ((Map)this.usageRemaining.getOrDefault(playerId, new HashMap())).getOrDefault(mor, 0);
    }
}

