/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.cards.c.CourtOfVantress;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.functions.CopyApplier;

class CourtOfVantressEffect
extends OneShotEffect {
    private static final CopyApplier applier = new CopyApplier(){

        public boolean apply(Game game, MageObject blueprint, Ability source, UUID targetObjectId) {
            blueprint.getAbilities().add((Object)CourtOfVantress.makeAbility());
            return true;
        }
    };

    CourtOfVantressEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose up to one other target enchantment or artifact. If you're the monarch, you may create a token that's a copy of it. If you're not the monarch, you may have {this} become a copy of it, except it has this ability";
    }

    private CourtOfVantressEffect(CourtOfVantressEffect effect) {
        super((OneShotEffect)effect);
    }

    public CourtOfVantressEffect copy() {
        return new CourtOfVantressEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (player == null || permanent == null) {
            return false;
        }
        if (source.isControlledBy(game.getMonarchId())) {
            return player.chooseUse(this.outcome, "Create a token copy of " + permanent.getIdName() + '?', source, game) && new CreateTokenCopyTargetEffect().setSavedPermanent(permanent).apply(game, source);
        }
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        if (sourcePermanent == null || !player.chooseUse(this.outcome, "Have " + sourcePermanent.getIdName() + " become a copy of " + permanent.getIdName() + '?', source, game)) {
            return false;
        }
        game.copyPermanent(Duration.Custom, permanent, sourcePermanent.getId(), source, applier);
        return true;
    }
}

