/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardTargetEffect;
import mage.abilities.effects.common.TargetPlayerGainControlSourceEffect;
import mage.abilities.effects.common.UntapSourceEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class CovetedJewelTriggeredAbility
extends TriggeredAbilityImpl {
    public CovetedJewelTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DrawCardTargetEffect(3), false);
        this.addEffect((Effect)new TargetPlayerGainControlSourceEffect());
        this.addEffect((Effect)new UntapSourceEffect());
    }

    private CovetedJewelTriggeredAbility(CovetedJewelTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public CovetedJewelTriggeredAbility copy() {
        return new CovetedJewelTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARE_BLOCKERS_STEP;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Player currentController = game.getPlayer(this.getControllerId());
        if (currentController == null) {
            return false;
        }
        for (UUID attacker : game.getCombat().getAttackers()) {
            Permanent attackingCreature = game.getPermanent(attacker);
            if (attackingCreature == null || !currentController.hasOpponent(attackingCreature.getControllerId(), game) || !this.getControllerId().equals(game.getCombat().getDefenderId(attacker)) || attackingCreature.isBlocked(game)) continue;
            this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId(), game));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever one or more creatures an opponent controls attack you and aren't blocked, that player draws three cards and gains control of {this}. Untap it.";
    }
}

