/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.StackAbility;

class CrackdownConstructTriggeredAbility
extends TriggeredAbilityImpl {
    CrackdownConstructTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new BoostSourceEffect(1, 1, Duration.EndOfTurn), false);
        this.setTriggerPhrase("Whenever you activate an ability of an artifact or creature that isn't a mana ability, ");
    }

    private CrackdownConstructTriggeredAbility(CrackdownConstructTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public CrackdownConstructTriggeredAbility copy() {
        return new CrackdownConstructTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ACTIVATED_ABILITY;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent source;
        if (event.getPlayerId().equals(this.getControllerId()) && (source = game.getPermanentOrLKIBattlefield(event.getSourceId())) != null && (source.isArtifact(game) || source.isCreature(game))) {
            StackAbility stackAbility = (StackAbility)game.getStack().getStackObject(event.getSourceId());
            return !stackAbility.getStackAbility().isManaActivatedAbility();
        }
        return false;
    }
}

