/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class CraftyCutpurseReplacementEffect
extends ReplacementEffectImpl {
    CraftyCutpurseReplacementEffect() {
        super(Duration.EndOfTurn, Outcome.GainControl);
        this.staticText = "each token that would be created under an opponent's control this turn is created under your control instead";
    }

    private CraftyCutpurseReplacementEffect(CraftyCutpurseReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public CraftyCutpurseReplacementEffect copy() {
        return new CraftyCutpurseReplacementEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE || event.getType() == GameEvent.EventType.CREATE_TOKEN;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Player controller;
        return event.getType() == GameEvent.EventType.CREATE_TOKEN && (controller = game.getPlayer(source.getControllerId())) != null && controller.hasOpponent(event.getPlayerId(), game);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            event.setPlayerId(controller.getId());
        }
        return false;
    }
}

