/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class CragganwickCrematorEffect
extends OneShotEffect {
    CragganwickCrematorEffect() {
        super(Outcome.Neutral);
        this.staticText = "discard a card at random. If you discard a creature card this way, {this} deals damage equal to that card's power to target player or planeswalker";
    }

    private CragganwickCrematorEffect(CragganwickCrematorEffect effect) {
        super((OneShotEffect)effect);
    }

    public CragganwickCrematorEffect copy() {
        return new CragganwickCrematorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card discardedCard = controller.discardOne(true, false, source, game);
            if (discardedCard != null && discardedCard.isCreature(game)) {
                int damage = discardedCard.getPower().getValue();
                return new DamageTargetEffect(damage).apply(game, source);
            }
            return true;
        }
        return false;
    }
}

