/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.common.ChooseACardNameEffect;
import mage.abilities.effects.common.search.SearchTargetGraveyardHandLibraryForCardNameAndExileEffect;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class CranialExtractionEffect
extends SearchTargetGraveyardHandLibraryForCardNameAndExileEffect {
    CranialExtractionEffect() {
        super(false, "target player's", "all cards with that name");
        this.staticText = "Choose a nonland card name. " + CardUtil.getTextWithFirstCharUpperCase((String)this.staticText);
    }

    private CranialExtractionEffect(CranialExtractionEffect effect) {
        super((SearchTargetGraveyardHandLibraryForCardNameAndExileEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || player == null) {
            return true;
        }
        String cardName = ChooseACardNameEffect.TypeOfName.NON_LAND_NAME.getChoice(controller, game, source, false);
        if (cardName == null) {
            return false;
        }
        super.applySearchAndExile(game, source, cardName, player.getId());
        return true;
    }

    public CranialExtractionEffect copy() {
        return new CranialExtractionEffect(this);
    }
}

