/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BecomesCreatureSourceEffect;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.custom.CreatureToken;
import mage.players.Player;

class CrawlingBarrensEffect
extends OneShotEffect {
    CrawlingBarrensEffect() {
        super(Outcome.Benefit);
        this.staticText = "Then you may have it become a 0/0 Elemental creature until end of turn. It's still a land.";
    }

    private CrawlingBarrensEffect(CrawlingBarrensEffect effect) {
        super((OneShotEffect)effect);
    }

    public CrawlingBarrensEffect copy() {
        return new CrawlingBarrensEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || !player.chooseUse(this.outcome, "Have this land become a 0/0 creature until end of turn?", source, game)) {
            return false;
        }
        game.addEffect((ContinuousEffect)new BecomesCreatureSourceEffect((Token)new CreatureToken(0, 0, "0/0 Elemental creature").withSubType(SubType.ELEMENTAL), CardType.LAND, Duration.EndOfTurn), source);
        return true;
    }
}

