/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class CrazedFirecatEffect
extends OneShotEffect {
    CrazedFirecatEffect() {
        super(Outcome.Benefit);
        this.staticText = "flip a coin until you lose a flip. Put a +1/+1 counter on {this} for each flip you won.";
    }

    private CrazedFirecatEffect(CrazedFirecatEffect effect) {
        super((OneShotEffect)effect);
    }

    public CrazedFirecatEffect copy() {
        return new CrazedFirecatEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourceObject = game.getPermanent(source.getSourceId());
        if (controller != null && sourceObject != null) {
            int flipsWon = 0;
            while (controller.flipCoin(source, game, true) && (!controller.isComputer() || ++flipsWon < 2)) {
            }
            sourceObject.addCounters(CounterType.P1P1.createInstance(flipsWon), source.getControllerId(), source, game);
            return true;
        }
        return false;
    }
}

