/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;

class CreamOfTheCropEffect
extends OneShotEffect {
    CreamOfTheCropEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top X cards of your library, where X is that creature's power. If you do, put one of those cards on top of your library and the rest on the bottom of your library in any order";
    }

    private CreamOfTheCropEffect(CreamOfTheCropEffect effect) {
        super((OneShotEffect)effect);
    }

    public CreamOfTheCropEffect copy() {
        return new CreamOfTheCropEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (controller != null && permanent != null) {
            CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, permanent.getPower().getValue()));
            if (!cards.isEmpty()) {
                TargetCard target = new TargetCard(Zone.LIBRARY, new FilterCard("card to put on top of your library"));
                target.withNotTarget(true);
                controller.chooseTarget(Outcome.Benefit, (Cards)cards, target, source, game);
                Card card = cards.get(target.getFirstTarget(), game);
                if (card != null) {
                    cards.remove(card);
                    controller.putCardsOnTopOfLibrary((Cards)new CardsImpl(card), game, source, true);
                }
                controller.putCardsOnBottomOfLibrary((Cards)cards, game, source, true);
            }
            return true;
        }
        return false;
    }
}

