/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceCardType;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

class CreepingRenaissanceEffect
extends OneShotEffect {
    CreepingRenaissanceEffect() {
        super(Outcome.Detriment);
        this.staticText = "Choose a permanent type. Return all cards of the chosen type from your graveyard to your hand";
    }

    private CreepingRenaissanceEffect(CreepingRenaissanceEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        ChoiceCardType typeChoice = new ChoiceCardType(true, Arrays.stream(CardType.values()).filter(CardType::isPermanentType).collect(Collectors.toList()));
        typeChoice.setMessage("Choose a permanent type");
        if (!controller.choose(Outcome.ReturnToHand, (Choice)typeChoice, game)) {
            return false;
        }
        String typeName = typeChoice.getChoice();
        CardType chosenType = CardType.fromString((String)typeChoice.getChoice());
        if (chosenType == null) {
            return false;
        }
        FilterCard filter = new FilterCard(chosenType.toString().toLowerCase(Locale.ENGLISH) + " card");
        filter.add((Predicate)chosenType.getPredicate());
        return controller.moveCards(controller.getGraveyard().getCards(filter, controller.getId(), source, game), Zone.HAND, source, game);
    }

    public CreepingRenaissanceEffect copy() {
        return new CreepingRenaissanceEffect(this);
    }
}

