/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ReturnSourceFromGraveyardToHandEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DieRolledEvent;
import mage.game.events.GameEvent;

class CriticalHitTriggeredAbility
extends TriggeredAbilityImpl {
    CriticalHitTriggeredAbility() {
        super(Zone.GRAVEYARD, (Effect)new ReturnSourceFromGraveyardToHandEffect());
    }

    private CriticalHitTriggeredAbility(CriticalHitTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DIE_ROLLED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        DieRolledEvent drEvent = (DieRolledEvent)event;
        return this.isControlledBy(event.getTargetId()) && drEvent.getNaturalResult() == 20;
    }

    public CriticalHitTriggeredAbility copy() {
        return new CriticalHitTriggeredAbility(this);
    }

    public String getRule() {
        return "When you roll a natural 20, return {this} from your graveyard to your hand.";
    }
}

