/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class CrosisThePurgerEffect
extends OneShotEffect {
    CrosisThePurgerEffect() {
        super(Outcome.Discard);
        this.staticText = "choose a color, then that player reveals their hand and discards all cards of that color.";
    }

    private CrosisThePurgerEffect(CrosisThePurgerEffect effect) {
        super((OneShotEffect)effect);
    }

    public CrosisThePurgerEffect copy() {
        return new CrosisThePurgerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        ChoiceColor choice = new ChoiceColor();
        player.choose(this.outcome, (Choice)choice, game);
        if (!choice.isChosen()) {
            return false;
        }
        game.informPlayers(player.getLogName() + " chooses " + choice.getColor());
        Player damagedPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (damagedPlayer == null) {
            return false;
        }
        damagedPlayer.revealCards("hand of " + damagedPlayer.getName(), damagedPlayer.getHand(), game);
        CardsImpl cards = new CardsImpl(damagedPlayer.getHand().getCards(game).stream().filter(card -> card.getColor(game).shares(choice.getColor())).collect(Collectors.toSet()));
        damagedPlayer.discard((Cards)cards, false, source, game);
        return true;
    }
}

