/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class CrowdControlWardenReplacementEffect
extends ReplacementEffectImpl {
    private static final DynamicValue xValue = new PermanentsOnBattlefieldCount((FilterPermanent)StaticFilters.FILTER_CONTROLLED_ANOTHER_CREATURE);

    CrowdControlWardenReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.BoostCreature);
        this.staticText = "as {this} enters or is turned face up, put X +1/+1 counters on it, where X is the number of other creatures you control";
    }

    private CrowdControlWardenReplacementEffect(CrowdControlWardenReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        switch (event.getType()) {
            case ENTERS_THE_BATTLEFIELD: 
            case TURN_FACE_UP: {
                return true;
            }
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent sourcePermanent;
        if (event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD && event.getTargetId().equals(source.getSourceId()) && (sourcePermanent = ((EntersTheBattlefieldEvent)event).getTarget()) != null && !sourcePermanent.isFaceDown(game)) {
            return true;
        }
        if (event.getType() == GameEvent.EventType.TURN_FACE_UP) {
            return event.getTargetId().equals(source.getSourceId());
        }
        return false;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        new AddCountersSourceEffect(CounterType.P1P1.createInstance(0), xValue, false).apply(game, source);
        return false;
    }

    public CrowdControlWardenReplacementEffect copy() {
        return new CrowdControlWardenReplacementEffect(this);
    }
}

