/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostAllEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class CrownOfConvergenceColorBoostEffect
extends BoostAllEffect {
    private static final String effectText = "creatures you control that share a color with that card get +1/+1";

    CrownOfConvergenceColorBoostEffect() {
        super(1, 1, Duration.WhileOnBattlefield, StaticFilters.FILTER_PERMANENT_CREATURE, false);
        this.staticText = effectText;
    }

    private CrownOfConvergenceColorBoostEffect(CrownOfConvergenceColorBoostEffect effect) {
        super((BoostAllEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player you = game.getPlayer(source.getControllerId());
        if (you != null) {
            Card topCard = you.getLibrary().getFromTop(game);
            if (topCard != null) {
                for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source.getControllerId(), source, game)) {
                    if (!permanent.getColor(game).shares(topCard.getColor(game)) || permanent.getColor(game).isColorless()) continue;
                    permanent.addPower(this.power.calculate(game, source, (Effect)this));
                    permanent.addToughness(this.toughness.calculate(game, source, (Effect)this));
                }
            }
            return true;
        }
        return false;
    }

    public CrownOfConvergenceColorBoostEffect copy() {
        return new CrownOfConvergenceColorBoostEffect(this);
    }
}

