/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class CruelUltimatumEffect
extends OneShotEffect {
    CruelUltimatumEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "You return a creature card from your graveyard to your hand, draw three cards, then gain 5 life";
    }

    private CruelUltimatumEffect(CruelUltimatumEffect effect) {
        super((OneShotEffect)effect);
    }

    public CruelUltimatumEffect copy() {
        return new CruelUltimatumEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard((FilterCard)StaticFilters.FILTER_CARD_CREATURE_YOUR_GRAVEYARD);
        controller.choose(Outcome.ReturnToHand, (Target)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card != null) {
            controller.moveCards(card, Zone.HAND, source, game);
        }
        controller.drawCards(3, source, game);
        controller.gainLife(5, game, source);
        return true;
    }
}

