/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class CrumbleEffect
extends OneShotEffect {
    CrumbleEffect() {
        super(Outcome.GainLife);
        this.staticText = "That artifact's controller gains life equal to its mana value";
    }

    private CrumbleEffect(CrumbleEffect effect) {
        super((OneShotEffect)effect);
    }

    public CrumbleEffect copy() {
        return new CrumbleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (permanent != null) {
            int cost = permanent.getManaValue();
            Player player = game.getPlayer(permanent.getControllerId());
            if (player != null) {
                player.gainLife(cost, game, source);
            }
            return true;
        }
        return false;
    }
}

