/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.Mana;
import mage.abilities.effects.mana.BasicManaEffect;
import mage.abilities.effects.mana.ManaEffect;
import mage.abilities.mana.TriggeredManaAbility;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.TappedForManaEvent;
import mage.game.permanent.Permanent;

class CryptGhastTriggeredAbility
extends TriggeredManaAbility {
    CryptGhastTriggeredAbility() {
        super(Zone.BATTLEFIELD, (ManaEffect)new BasicManaEffect(Mana.BlackMana((int)1)), false);
        this.usesStack = false;
    }

    private CryptGhastTriggeredAbility(CryptGhastTriggeredAbility ability) {
        super((TriggeredManaAbility)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TAPPED_FOR_MANA;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent land = ((TappedForManaEvent)event).getPermanent();
        return land != null && land.isControlledBy(this.getControllerId()) && land.hasSubtype(SubType.SWAMP, game);
    }

    public CryptGhastTriggeredAbility copy() {
        return new CryptGhastTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever you tap a Swamp for mana, add an additional {B}.";
    }
}

