/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class CullingDaisEffect
extends OneShotEffect {
    CullingDaisEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Draw a card for each charge counter on {this}";
    }

    private CullingDaisEffect(CullingDaisEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent p = (Permanent)game.getLastKnownInformation(source.getSourceId(), Zone.BATTLEFIELD);
        Player player = game.getPlayer(source.getControllerId());
        if (p != null && player != null) {
            int count = p.getCounters(game).getCount(CounterType.CHARGE);
            player.drawCards(count, source, game);
            return true;
        }
        return false;
    }

    public CullingDaisEffect copy() {
        return new CullingDaisEffect(this);
    }
}

