/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamagePlayersEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.game.permanent.token.TreasureToken;
import mage.players.Player;
import mage.util.CardUtil;

class CulminationOfStudiesEffect
extends OneShotEffect {
    private static final FilterCard filterBlue = new FilterCard();
    private static final FilterCard filterRed = new FilterCard();

    CulminationOfStudiesEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top X cards of your library. For each land card exiled this way, create a Treasure token. For each blue card exiled this way, draw a card. For each red card exiled this way, {this} deals 1 damage to each opponent";
    }

    private CulminationOfStudiesEffect(CulminationOfStudiesEffect effect) {
        super((OneShotEffect)effect);
    }

    public CulminationOfStudiesEffect copy() {
        return new CulminationOfStudiesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, ((Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0)).intValue()));
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        cards.removeIf(uuid -> game.getState().getZone(uuid) != Zone.EXILED);
        int landCards = cards.count((FilterCard)StaticFilters.FILTER_CARD_LAND, game);
        int blueCards = cards.count(filterBlue, game);
        int redCards = cards.count(filterRed, game);
        if (landCards > 0) {
            new TreasureToken().putOntoBattlefield(landCards, game, source, source.getControllerId());
        }
        if (blueCards > 0) {
            player.drawCards(blueCards, source, game);
        }
        if (redCards > 0) {
            new DamagePlayersEffect(redCards, TargetController.OPPONENT).apply(game, source);
        }
        return true;
    }

    static {
        filterBlue.add((Predicate)new ColorPredicate(ObjectColor.BLUE));
        filterRed.add((Predicate)new ColorPredicate(ObjectColor.RED));
    }
}

