/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;
import mage.util.CardUtil;

class CultivatorColossusEffect
extends OneShotEffect {
    CultivatorColossusEffect() {
        super(Outcome.PutLandInPlay);
        this.staticText = "you may put a land card from your hand onto the battlefield tapped. If you do, draw a card and repeat this process";
    }

    private CultivatorColossusEffect(CultivatorColossusEffect effect) {
        super((OneShotEffect)effect);
    }

    public CultivatorColossusEffect copy() {
        return new CultivatorColossusEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        while (player.canRespond() && player.getHand().count((FilterCard)StaticFilters.FILTER_CARD_LAND, game) > 0) {
            TargetCardInHand target = new TargetCardInHand(0, 1, (FilterCard)StaticFilters.FILTER_CARD_LAND);
            player.choose(this.outcome, (Target)target, source, game);
            Card card = game.getCard(target.getFirstTarget());
            if (card == null) break;
            player.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, false, null);
            Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
            if (permanent == null) continue;
            player.drawCards(1, source, game);
        }
        return true;
    }
}

