/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.c.CurseOfChaosEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class CurseOfChaosTriggeredAbility
extends TriggeredAbilityImpl {
    public CurseOfChaosTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CurseOfChaosEffect(), false);
        this.setTriggerPhrase("Whenever a player attacks enchanted player with one or more creatures, ");
    }

    private CurseOfChaosTriggeredAbility(CurseOfChaosTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent enchantment = game.getPermanent(this.getSourceId());
        if (enchantment != null && enchantment.getAttachedTo() != null && game.getCombat().getPlayerDefenders(game, false).contains(enchantment.getAttachedTo())) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(game.getCombat().getAttackingPlayerId()));
            }
            return true;
        }
        return false;
    }

    public CurseOfChaosTriggeredAbility copy() {
        return new CurseOfChaosTriggeredAbility(this);
    }
}

