/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.ZombieToken;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class CurseOfDisturbanceEffect
extends OneShotEffect {
    CurseOfDisturbanceEffect() {
        super(Outcome.Benefit);
        this.staticText = "create a 2/2 black Zombie creature token. Each opponent attacking that player does the same.";
    }

    private CurseOfDisturbanceEffect(CurseOfDisturbanceEffect effect) {
        super((OneShotEffect)effect);
    }

    public CurseOfDisturbanceEffect copy() {
        return new CurseOfDisturbanceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent enchantment = source.getSourcePermanentOrLKI(game);
        if (enchantment != null) {
            Player enchantedPlayer = game.getPlayer(enchantment.getAttachedTo());
            if (enchantedPlayer != null) {
                HashSet<UUID> players = new HashSet<UUID>();
                for (UUID attacker : game.getCombat().getAttackers()) {
                    UUID defender = game.getCombat().getDefenderId(attacker);
                    if (!defender.equals(enchantedPlayer.getId()) || !game.getPlayer(source.getControllerId()).hasOpponent(game.getPermanent(attacker).getControllerId(), game)) continue;
                    players.add(game.getPermanent(attacker).getControllerId());
                }
                players.add(source.getControllerId());
                for (UUID player : players) {
                    game.getPlayer(player);
                    CreateTokenTargetEffect effect = new CreateTokenTargetEffect((Token)new ZombieToken());
                    effect.setTargetPointer((TargetPointer)new FixedTarget(player));
                    effect.apply(game, source);
                }
            }
            return true;
        }
        return false;
    }
}

